#include <iostream>
#include "../../fractal_printer.h"
#include "../../coord.h"
#include "../../rulegraph.h"
#include "../../usr_div_policy.h"
#include "../../mouse.h"
#include <string>
#include <math.h>


class painter
{
public :
    void draw (const coord_math::coord& u_fcoord, const coord_math::coord& u_scoord, const int n_rec, const int max_r)
    {

        if (n_rec == max_r)
        {
            line(ceil(u_fcoord.first), ceil(u_fcoord.second), ceil(u_scoord.first), ceil(u_scoord.second));
        }

    }
};

class messages_printer
{
public :
    void operator()(int y, char* mes)
    {
        outtextxy(10, y, mes);
    }
    void operator()(const std::string& mes)
    {
        std::cout << mes << std::endl ;
    }
};



int main()
{
    messages_printer print ;
    int n_rec ;
    print("vvedite glubinu fractala (luchshe ~5)");
    std::cin >> n_rec ;
    rule_graph::graph gr;

    srand((unsigned)time(NULL));
    print(10, "pokazjite otrezok iz kotorogo budet postroen fractal i nazmite enter");
    coord_math::pair_coord user_line = mouse::get_pair_coord_if(WM_LBUTTONDOWN);
    getch();
    clearviewport();
    print(10, "teper na primere etogo otrezka, pokazite cto narrisovat vmesto");
    print(30, "narisovannii vami otrzoka i nazmite pravoi knopkoi mishi");
    fract::fractal_printer<u_div_policy, painter> p ;
    p.print_fractal(user_line.first, user_line.second, n_rec);
    print(10, "eto vse, press any key");
    getch();
    return 0;
}
